$TITLE: JGEA2

* extends model JGEA1 by adding a tax and a (iceberg) transactions cost
* and showing the substantial difference between the two

PARAMETERS
 LBAR     labor endowment
 KBAR     capital endowment
 TC       iceberg transportation (trade) cost on a gross basis (1+tc)
 TR       tax on a gross basis (1+tr)
 WELFARE  welfare;

LBAR = 100;
KBAR = 100;
TC = 1;  TR = 1;

NONNEGATIVE VARIABLES

 U       activity level for utility or welfare
 X       activity level for X production
 Y       activity level for Y production

 W       price of labor
 R       price of capital
 PX      price of good X
 PY      price of good Y
 PU      price of welfare (expenditure function)

 I       income of the representative consumer;

EQUATIONS

 PRF_U   zero profit for welfare
 PRF_X   zero profit for sector X
 PRF_Y   zero profit for sector Y

 MKT_L   supply-demand balance for primary factor L
 MKT_K   supply-demand balance for primary factor K
 MKT_X   supply-demand balance for commodity X
 MKT_Y   supply-demand balance for commodity Y
 MKT_U   supply-demand balance for welfare

 INC_I   income balance;

*       Zero profit inequalities

PRF_U..      PX**0.5 * PY**0.5 =G= PU;

PRF_X..      W**0.25 * R**0.75 * TC * TR =G= PX;

PRF_Y..      W**0.75 * R**0.25 =G= PY;

*       Market clearance inequalities

MKT_L..      LBAR =G= 0.25*(R/W)**0.75*X  +
                      0.75*(R/W)**0.25*Y;

MKT_K..      KBAR =G= 0.75*(W/R)**0.25*X +
                      0.25*(W/R)**0.75*Y;

MKT_X..      X/TC =G= 0.5*U*PU/PX;

MKT_Y..      Y    =G= 0.5*U*PU/PY;

MKT_U..      U    =G= I/PU;

*       Income balance equation

INC_I..      I =E= LBAR*W + KBAR*R + (TR-1)*(W**0.25*R**0.75)*X;


MODEL CLOSED /PRF_U.U, PRF_X.X, PRF_Y.Y,
              MKT_L.W, MKT_K.R, MKT_X.PX, MKT_Y.PY, MKT_U.PU,
              INC_I.I /;

*       Chose a numeraire: price of U fixed (.FX) at 1

PU.FX = 1;

*       Set initial values of variables (.L notation after variable)

X.L=100; Y.L=100; U.L = 100; I.L=200;
PX.L=1; PY.L=1; R.L=1; W.L=1; PU.L = 1;

SOLVE CLOSED USING MCP;

* SHOW HOW TO DO MULTIPLE SCENARIOS
* SHOW DIFFERENCE BETWEEN TARIFF AND TRADE COST OF EQUAL RATES

SETS T indexes 25 different gross cost levels         /T1*T25/
     J indexes 2 scenarios: 1 = tariff 2 = trade cost /J1*J2/;

PARAMETERS
 RATE(T)          net tax or trade cost rate (gross rate minus 1)
 WELFARE(T,J)     welfare normalized to equal 1 in benchmark
 RESULTS(T, *)    formats results in one table;

LOOP(J,
LOOP(T,

TC = 1; TR = 1;
RATE(T) = 1 + .05*ORD(T) - 0.05;
TR$(ORD(J) EQ 1) = RATE(T);
TC$(ORD(J) EQ 2) = RATE(T);

SOLVE CLOSED USING MCP;

WELFARE(T,J) = U.L;

);
);

RESULTS(T, "RATE") = RATE(T)-1;
RESULTS(T, "WELTR") = WELFARE(T, "J1")/200;
RESULTS(T, "WELTC") = WELFARE(T, "J2")/200;

DISPLAY RESULTS;

* Write parameter RESULTS to an Excel file JGEA.XLS,
* starting in Sheet1

Execute_Unload 'JGEA.gdx' RESULTS
execute 'gdxxrw.exe JGEA.gdx par=RESULTS rng=SHEET1!'
